#version 330

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in float vertex_brightness;
layout(location = 2) in vec2 vertex_omega_phi;

out float brightness;
out vec2 omega_phi;

uniform mat4 world_to_clip;
uniform bool position_as_cartesian;

void main()
{
    vec3 xyz_position = vertex_position;
    if (!position_as_cartesian)
    {
        float r = vertex_position.x;
        float inclination = vertex_position.y;
        float azimuth = vertex_position.z;

        xyz_position = r * vec3(sin(inclination) * cos(azimuth),
                                sin(inclination) * sin(azimuth),
                                cos(inclination));
    }
    
    gl_Position = world_to_clip * vec4(xyz_position, 1.0);
    brightness = vertex_brightness;
    omega_phi = vertex_omega_phi;
}